;*******************************
;*   DEMONTRATION PROGRAM 10   *
;*             LCD             *
;*******************************
;
            ORG    8000H
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
SCAN_KYDP   EQU    27H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
TWO_IN_ONE  EQU    2EH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
GET_2KEY    EQU    12H             ;   "     "
HEX_2_SEG   EQU    15H
COMMAND     EQU    0E0ACH    ; Read-Write Register
READBUSY    EQU    0E0ADH    ; Read BF(Busy Flag) and address
WRITEDATA   EQU    0E0AEH    ; Write character
READDATA    EQU    0E0AFH    ; Read Data from DD ram
SYSCALL     EQU    0030H     ; System call

DEM10:      MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    PSW,#0

START:      LCALL   INIT
STR2:       MOV     R0,#20
            MOV     DPTR,#TABLE1
STR1:       MOVX    A,@DPTR        ;Get character
            LCALL   WRITE_CHR      ;Write to LCD
            INC     DPTR           ;Next
            LCALL   DELAY
            DJNZ    R0,STR1

            MOV     A,#04H
            MOV     DPTR,#COMMAND
            MOVX    @DPTR,A
            LCALL   WAITBF
            MOV     A,#53H         ;New Address
            LCALL   GOTOXY
            MOV     DPTR,#TABLE2+19
            MOV     R0,#20
ST2:        MOVX    A,@DPTR
            LCALL   WRITE_CHR
            MOV     A,DPL
            JNZ     DEC_DPL
            DEC     DPH
DEC_DPL:    DEC     DPL
            LCALL   DELAY
            DJNZ    R0,ST2

            LCALL   DELAY
            MOV     R2,#60
            MOV     A,#1CH                 ;Shift right display
            MOV     DPTR,#COMMAND
ST3:        MOVX    @DPTR,A
            LCALL   WAITBF
            LCALL   DELAY
            DJNZ    R2,ST3
            LCALL   DELAY

            MOV     R2,#80
            MOV     A,#18H                ;Shift rigth display
            MOV     DPTR,#COMMAND
ST4:        MOVX    @DPTR,A
            LCALL   DELAY
            DJNZ    R2,ST4

            LCALL   DELAY
            LCALL   DELAY
            MOV     A,#1
            MOVX    @DPTR,A
            LCALL   DELAY
            SJMP    STR2


INIT:       MOV     DPTR,#COMMAND
            MOV     A,#38H         ;8bit, 2 line, 5x7 dot
            MOVX    @DPTR,A        ;Write instruction
            LCALL   WAITBF         ;Wait LCD ready
            MOV     A,#0CH         ;Display-on,cursor-off & blink
            MOVX    @DPTR,A
            LCALL   WAITBF
            MOV     A,#6           ;cursor increment
            MOVX    @DPTR,A
            LCALL   WAITBF
            MOV     A,#1           ;clear display and home
            MOVX    @DPTR,A
            LCALL   WAITBF
            LCALL   WAITBF
            RET


; *** Write ASCII to LCD ***

WRITE_CHR:  PUSH    DPL
            PUSH    DPH
            LCALL   WAITBF
            MOV     DPTR,#WRITEDATA
            MOVX    @DPTR,A
            LCALL   WAITBF     ;Wait LCD module ready
            POP     DPH
            POP     DPL
            RET

; *** Wait for ready ,check busy flag ***

WAITBF:    PUSH    DPL
           PUSH    DPH
           PUSH    ACC
           MOV     DPTR,#READBUSY
RDY1:      MOVX    A,@DPTR
           JB      ACC.7,RDY1     ;Busy Flag
           POP     ACC
           POP     DPH
           POP     DPL
           RET
;*
;* Go to address of LCD *
;*
GOTOXY:    MOV     DPTR,#COMMAND
           SETB    ACC.7          ;Set DDRAM instruction
           MOVX    @DPTR,A
           LCALL   WAITBF         ;Wait busy flag
           RET

           ;*
           ;* Delay
           ;*
DELAY:     PUSH    DPL
           PUSH    DPH
           PUSH    ACC
           MOV     DPTR,#0A000H
DLY1:      INC     DPTR
           MOV     A,DPL
           ORL     A,DPH
           JNZ     DLY1
           POP     ACC
           POP     DPH
           POP     DPL
           RET


TABLE1:    DB  ' *LCD-20 CHARACTER* '
TABLE2:    DB  'demo use instruction'

           END
